unit mTestTermBaum;

interface

uses
  Windows, Messages, SysUtils,  Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, mToken, mBinTree, Math, ExtCtrls;

type
  TfrmTermBaum = class(TForm)
    ButtonSchliessen: TButton;
    edAusgabe: TEdit;
    btPreOrder: TButton;
    btPostOrder: TButton;
    btInOrder: TButton;
    btBaum: TButton;
    btBaumAusPreOrder: TButton;
    imBaum: TImage;
    btWert: TButton;
    procedure FormCreate(Sender: TObject);

    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonSchliessenClick(Sender: TObject);
    procedure btPreOrderClick(Sender: TObject);
    procedure btPostOrderClick(Sender: TObject);
    procedure btInOrderClick(Sender: TObject);
    procedure btBaumClick(Sender: TObject);
    procedure btBaumAusPreOrderClick(Sender: TObject);
    procedure btWertClick(Sender: TObject);
  private
    { Private-Deklarationen }
     hTermWurzel : TBinTree;
     Ausgabe : String;
     Position : integer;
  public
    procedure PreOrderAusgabe(b : TBinTree);
    procedure PostOrderAusgabe(b : TBinTree);
    procedure InOrderAusgabe(b : TBinTree);
    function PreOrderAus(b : TBinTree):String;
    function Hoehe(b : TBintree):integer;
    procedure BaumAnzeigen (AktKnoten:TBinTree; Tiefe,X,DX: Integer);
    function getToken:string;
    function baumAusPre : TBinTree;
    function Wert(b : TBinTree) : integer;
  end;
const Rechenzeichen : set of char = ['+','-','*','/'];
const Ziffern : set of char = ['0'..'9'];
var
  frmTermBaum: TfrmTermBaum;

implementation {$R *.dfm}

function TfrmTermBaum.Wert(b : TBinTree) : integer;
var Zahl1, Zahl2 : integer;
begin
  if TToken(b.getRootItem).istZahl
  then Wert :=  TToken(b.getRootItem).getZahl
  else begin
    Zahl1 := Wert(b.getLeftTree);
    Zahl2 := Wert(b.getRightTree);
    case TToken(b.getRootItem).getZeichen of
      '+' : Wert := Zahl1 + Zahl2;
      '-' : Wert := Zahl1 - Zahl2;
      '*' : Wert := Zahl1 * Zahl2;
      '/' : Wert := Zahl1 div Zahl2;
    end;
  end;

end;

procedure TfrmTermBaum.FormCreate(Sender: TObject);
var
  LBaum3Links, lBaum3Rechts, lBaum2Links, lBaum2Rechts,lBaum1Links, lBaum1Rechts:TBintree;
   begin
   // TermBaum aufbauen : (3+4)*7 - 13*(17-50)
      lBaum3Links := TBintree.create(TToken.create(' ',3));
      lBaum3Rechts := TBintree.create(TToken.create(' ',4));
      lBaum2Links := TBintree.create(TToken.create('+',0),lBaum3Links,lBaum3Rechts);
      lBaum2Rechts := TBintree.create(TToken.create(' ',7));
      lBaum1Links := TBintree.create(TToken.create('*',0),lBaum2Links,lBaum2Rechts);
      lBaum2Links := TBintree.create(TToken.create(' ', 13));
      lBaum3Links := TBintree.create(TToken.create(' ',17));
      lBaum3Rechts := TBintree.create(TToken.create(' ', 50));
      lBaum2Rechts := TBintree.create(TToken.create('-',0),lBaum3Links,lBaum3Rechts);
      lBaum1Rechts := TBintree.create(TToken.create('*',0),lBaum2Links,lBaum2Rechts);
      hTermWurzel :=  TBintree.create(TToken.create('-',0),lBaum1Links,lBaum1Rechts);
   edAusgabe.Text := 'Baumhhe: ' + IntToStr(Hoehe(hTermWurzel));
   // Canvas noch nicht da !      BaumAnzeigen(hTermWurzel,0,380,190);
end;



procedure TfrmTermBaum.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  hTermWurzel.destroy;
end;

procedure TfrmTermBaum.ButtonSchliessenClick(Sender: TObject);
begin

  close
end;

procedure TfrmTermBaum.btPreOrderClick(Sender: TObject);
begin
  Ausgabe := '';
  //PreOrderAusgabe(hTermWurzel);
  edAusgabe.Text := PreOrderAus(hTermWurzel)//Ausgabe;
end;

procedure TfrmTermBaum.PreOrderAusgabe(b : TBinTree);
var t : TToken;
begin
  if (b<>nil) and (b.getRootItem <> nil) then begin
    t := TToken(b.getRootItem);
    if t.getZeichen <> ' '
    then Ausgabe := Ausgabe +  t.getZeichen
    else Ausgabe := Ausgabe + IntToStr(t.getZahl) + ' ';
    PreOrderAusgabe(b.getLeftTree);
    PreOrderAusgabe(b.getRightTree);
  end;
end;

function TfrmTermBaum.PreOrderAus(b : TBinTree):String;
var t : TToken; s:String;
begin
  if (b=nil) or (b.getRootItem = nil)
  then result := ''
  else begin
    t := TToken(b.getRootItem);
    if t.istZahl
    then s := intToStr(t.getZahl) + ' '
    else s := t.getZeichen + ' ';
    result := s +  PreOrderAus(b.getLeftTree) +  PreOrderAus(b.getRightTree);
  end;
end;

procedure TfrmTermBaum.PostOrderAusgabe(b : TBinTree);
var t : TToken;
begin
  if (b<>nil) and (b.getRootItem <> nil) then begin
    PostOrderAusgabe(b.getLeftTree);
    PostOrderAusgabe(b.getRightTree);
    t := TToken(b.getRootItem);
    if t.getZeichen <> ' '
    then Ausgabe := Ausgabe +  t.getZeichen
    else Ausgabe := Ausgabe + IntToStr(t.getZahl) + ' ';

  end;
end;

procedure TfrmTermBaum.InOrderAusgabe(b : TBinTree);
var t : TToken;
    h : Integer;
begin
  if (b<>nil) and (b.getRootItem <> nil) then begin
    h := Hoehe(b);
    if h > 1 then Ausgabe := Ausgabe +  '(';
    InOrderAusgabe(b.getLeftTree);

    t := TToken(b.getRootItem);
    if t.getZeichen <> ' '
    then Ausgabe := Ausgabe +  t.getZeichen
    else Ausgabe := Ausgabe + IntToStr(t.getZahl) + ' ';
    InOrderAusgabe(b.getRightTree);
    if h > 1 then Ausgabe := Ausgabe +  ')';
  end;
end;
function TfrmTermBaum.Hoehe(b : TBintree):integer;
begin
  if (b=nil) or (b.getRootItem = nil)
  then Hoehe := 0
  else Hoehe := 1+max(Hoehe(b.getLeftTree), Hoehe(b.getRightTree));
end;
procedure TfrmTermBaum.btPostOrderClick(Sender: TObject);
begin
   Ausgabe := '';
  PostOrderAusgabe(hTermWurzel);
  edAusgabe.Text := Ausgabe;
end;

procedure TfrmTermBaum.btInOrderClick(Sender: TObject);
begin
   Ausgabe := '';
  InOrderAusgabe(hTermWurzel);
  edAusgabe.Text := Ausgabe;
end;

procedure TfrmTermBaum.BaumAnzeigen (AktKnoten:TBinTree; Tiefe,X,DX: Integer);
var Inhalt: TToken;
    InhaltStr : String;
    XPos,YPos: Integer;
    DY: Integer;
begin
  
  DY := 40;                                  {= Vertikaler Knotenabstand}
  if not AktKnoten.IsEmpty
    then begin
      DX := DX div 2;
      XPos := X;
      YPos := Tiefe*DY + 50;

      if not AktKnoten.GetRightTree.isEmpty
      then begin
        imBaum.Canvas.MoveTo (XPos,YPos);
        imBaum.Canvas.LineTo (XPos+DX,YPos+DY);
      end;
      BaumAnzeigen (AktKnoten.GetRightTree,Tiefe+1,X+DX,DX);



      if not AktKnoten.GetLeftTree.IsEmpty
      then begin
        imBaum.Canvas.MoveTo (XPos,YPos);
        imBaum.Canvas.LineTo (XPos-DX,YPos+DY);
      end;
      //erst hier, damit die Ellipse ueber den Linien gezeichnet wird
      Inhalt := TToken(AktKnoten.getRootItem);
      imBaum.Canvas.Ellipse (XPos-10,YPos-5,XPos+25,YPos+15);
      if Inhalt.getZeichen <> ' '
      then InhaltStr := Inhalt.getZeichen
      else InhaltStr :=  IntToStr(Inhalt.getZahl) ;
      imBaum.Canvas.TextOut (XPos,YPos-3,InhaltStr);

      BaumAnzeigen (AktKnoten.GetLeftTree,Tiefe+1,X-DX,DX);
    end
end;
procedure TfrmTermBaum.btBaumClick(Sender: TObject);
begin
  BaumAnzeigen(hTermWurzel,0,380,190);
end;

procedure TfrmTermBaum.btBaumAusPreOrderClick(Sender: TObject);
begin
  Ausgabe := edAusgabe.Text;
  Position := 1;
  hTermWurzel := baumAusPre;
end;
function TfrmTermBaum.getToken:string;
var e : string;
begin
  while (Position <= Length(Ausgabe)) and (Ausgabe[Position] =' ') do inc(Position);
  if (Position <= Length(Ausgabe)) and (Ausgabe[Position] in RechenZeichen)
  then begin getToken := Ausgabe[Position]; inc(Position) end
  else 
    if Position > Length(Ausgabe)
    then getToken := 'E'
    else begin
      e := '';
      while (Position <= Length(Ausgabe)) and (Ausgabe[Position] in Ziffern)
      do begin
        e := e + Ausgabe[Position];
        inc(Position);
      end;
      getToken := e
    end
end;
function TfrmTermBaum.baumAusPre : TBinTree;
var ts:string; links, rechts : TBinTree;
begin
  if Position <= Length(Ausgabe)
  then  begin
     ts := getToken;
     if ts[1] in Ziffern
     then result :=  TBinTree.create(TToken.Create(' ',strToInt(ts)))
     else
        if ts[1] = 'E'
        then  result :=  TBinTree.create(TToken.Create('E',0))
        else  begin
           links := baumAusPre;
           rechts := baumAusPre;
           result :=  TBinTree.create(TToken.Create(ts[1],0),
                                         links, rechts);
        end
   end
   else result := nil;
end;
procedure TfrmTermBaum.btWertClick(Sender: TObject);
begin
  edAusgabe.Text := intToStr (Wert(hTermWurzel));
end;

end.
